<?php
// share_document.php
session_start();
require 'db_connection.php'; 

if (!isset($_SESSION['user_id'])) {
    die(json_encode(['status' => 'error', 'message' => 'Unauthorized access.']));
}

$sender_id = $_SESSION['user_id'];
$document_id = filter_input(INPUT_POST, 'document_id', FILTER_VALIDATE_INT);
$recipient_name = htmlspecialchars(trim($_POST['recipient_name'] ?? ''));
$recipient_email = filter_var(trim($_POST['recipient_email'] ?? ''), FILTER_SANITIZE_EMAIL);

if (!$document_id || !$recipient_name || !$recipient_email) {
    die(json_encode(['status' => 'error', 'message' => 'Invalid input data.']));
}

// 1. Unified Check: Internal or External
$stmt = $pdo->prepare("SELECT user_id FROM users WHERE email = ?");
$stmt->execute([$recipient_email]);
$internal_user = $stmt->fetch();
$recipient_user_id = $internal_user ? $internal_user['user_id'] : null;

// 2. Generate the Secure Token
$access_token = bin2hex(random_bytes(32)); 

try {
    // 3. Save to Database
    $insert_stmt = $pdo->prepare("
        INSERT INTO document_shares 
        (document_id, sender_id, recipient_user_id, recipient_name, recipient_email, access_token, status) 
        VALUES (?, ?, ?, ?, ?, ?, 'shared')
    ");
    $insert_stmt->execute([$document_id, $sender_id, $recipient_user_id, $recipient_name, $recipient_email, $access_token]);
    
    // 4. Dispatch the Production Email
    // IMPORTANT: Update this domain to your actual live testing domain
    $portal_domain = "http://smartprojects.sc.ug"; 
    $magic_link = $portal_domain . "/access.php?token=" . $access_token;
    
    $subject = "Secure Document Shared with You (NCDC)";
    $message = "Hello $recipient_name,\n\n";
    $message .= "A secure document has been shared with you via the National Curriculum Development Centre portal.\n";
    $message .= "Click the link below to access it. For security, you will be prompted to verify your email.\n\n";
    $message .= $magic_link . "\n\n";
    $message .= "This link is unique to you. Do not forward it.";
    
    $headers = "From: secure-system@ncdc.go.ug\r\n";
    
    // Send the email
    mail($recipient_email, $subject, $message, $headers);
    
    echo json_encode(['status' => 'success', 'message' => 'Secure link generated and emailed successfully.']);
    
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'System error during sharing process.']);
}
?>